package IMPL::Config::ValueDescriptor;
use strict;

use IMPL::lang qw(:base);
use IMPL::declare {
    require => {
        Descriptor => 'IMPL::Config::Descriptor'
    },
    base => [
        'IMPL::Object' => undef,
        'Descriptor'   => undef
    ],
    props => [
        value    => 'rw',
        raw      => 'rw',
        services => 'rw'
    ]
};

sub CTOR {
    my ( $this, $value, %opts) = @_;

    $this->value($value);
    $this->raw($opts{raw}) if exists $opts{raw};
    $this->services($opts{services}) if exists $opts{services};
}

sub Activate {
    my ( $this, $context ) = @_;
    return $this->value if $this->raw;

    my $services = $this->services;

    $context->EnterScope( '$value: ' . $this->value, $services ) if $services;
    my $value = $this->_ActivateValue( $this->value, $context );
    $context->LeaveScope() if $services;
    return $value;
}

sub _ActivateValue {
    my ( $this, $value, $context ) = @_;

    if ( is( $value, Descriptor ) ) {
        return $value->Activate($context);
    }
    elsif ( isarray($value) ) {
        return [ map $this->_ActivateValue( $_, $context ), @$value ];
    }
    elsif ( ishash($value) ) {
        return {
            map { $_, $this->_ActivateValue( $value->{$_}, $context ) }
              keys %$value
        };
    }
    else {
        return $value;
    }
}

1;
