package IMPL::Object::List;
use strict;
use warnings;

use base qw(IMPL::Object::ArrayObject);

sub as_list {
    return $_[0];
}

sub Append {
    push @{$_[0]}, @_{1 .. @$_-1};
}

sub RemoveLast {
    return pop @{$_[0]};
}

sub AddFirst {
    return unshift @{$_[0]}, $_[1];
}

sub RemoveFirst {
    return shift @{$_[0]};
}

sub Count {
    return scalar @{$_[0]};
}

sub InsertAt {
    my ($this,$index,@val) = @_;
    
    splice @$this,$index,0,@val;
}

sub RemoveAt {
    my ($this,$index,$count) = @_;
    
    $count ||= 1;
    
    return splice @$this,$index,$count;
}

1;
