package IMPL::Class::PropertyInfo;
use strict;

use base qw(IMPL::Class::MemberInfo);

__PACKAGE__->mk_accessors(qw(Type Mutators canGet canSet));
__PACKAGE__->PassThroughArgs;

our @Implementors = ( ['IMPL::Object' => 'IMPL::Class::Property::Direct'] );

my %LoadedModules;

sub CTOR {
    my $this = shift;
    
    my $implementor = $this->Implementor($this->SelectImplementor());
    if (my $class = ref $implementor ? undef : $implementor) {
        if (not $LoadedModules{$class}) {
            (my $package = $class.'.pm') =~ s/::/\//g;
            require $package;
            $LoadedModules{$class} = 1;
        }
    }
    
    $this->Mutators(0) unless defined $this->Mutators;
}

sub SelectImplementor {
    my ($this) = @_;
    
    foreach my $item (@Implementors) {
        return $item->[1] if $this->Class->isa($item->[0]);
    }
    
    die new IMPL::Exception('Can\'t find a property implementor for the specified class',$this->Class);
}

1;
