package IMPL::Web::Security;
use strict;
use base qw(IMPL::Object IMPL::Security IMPL::Object::Autofill);

require IMPL::Web::Security::Session;

use IMPL::Class::Property;
use IMPL::Security::Auth qw(:Const);

__PACKAGE__->PassThroughArgs;

BEGIN {
	public property sourceUser => prop_all;
	public property sourceSession => prop_all;
}

sub AuthUser {
	my ($this,$name,$package,$challenge) = @_;
	
	my $user = $this->sourceUser->find({name => $name});
	
	my $auth;	
	if ( my $secData = $user->secData($package) ) {
		$auth = $package->new($secData);
	} else {
		die new IMPL::SecurityException("Authentication failed","A sec data for the $package isn't found");
	}
	
	my ($status,$answer) = $auth->DoAuth($challenge);
	
	if ($status == AUTH_FAIL) {
		die new IMPL::SecurityException("Authentication failed","DoAuth failed");
	}
	
	return {
		status => $status,
		answer => $answer,
		context => $this->MakeContext( $user, [$user->roles], $auth )
	}
}

sub MakeContext {
	my ($this,$principal,$roles,$auth) = @_;
	
	return $this->sourceSession->create(
		{
			principal => $principal,
			rolesAssigned => $roles,
			auth => $auth
		}
	);
}

1;

__END__

=pod

=head1 NAME

C<IMPL::Web::Security>       .

=head1 SINOPSYS

=begin code xml

<security type='IMPL::Config::Activator'>
	<factory>IMPL::Web::Security</factory>
	<parameters type='HASH'>
		<sessionFactory type='IMPL::Object::Factory'>
			<factory type='IMPL::Object::Factory'>App::Data::Session</factory>
			<method>insert</method>
		</sessionFactory>
	</parameters>
</security>

=end code xml

=head1 DESCRIPTION

      .  
  ,       ,  
    .      
  .      
 .

C<IMPL::Web::Session>        
.      ,  
   .

C<IMPL::Web::User> ,     
C<IMPL::Security::Principal>,        
 C<IMPL::Security::Auth>.

=head1 MEMBERS

=cut