package Security::Auth::Simple;
use strict;
use Common;

our $Strict;

our @ISA = qw(Object);

sub Name {
    return 'Simple';
}

sub ConstructAuthData {
    my ($class,$SecData) = @_;
    return new Security::Auth::Simple::AuthData(DataMD5 => $SecData);
}

sub NewAuthData {
    my ($class,$SecData) = @_;
    return new Security::Auth::Simple::AuthData(Data => $SecData);
    
}

package Security::Auth::Simple::AuthData;
use Common;
use Security;
use Security::Auth;
use Digest::MD5 qw(md5_hex);
our @ISA = qw(Object);

BEGIN {
    DeclareProperty Data => ACCESS_READ;
    DeclareProperty DataMD5 => ACCESS_READ;
}

sub CTOR {
    my ($this,%args) = @_;
    
    if ($args{'Data'}) {
        $args{'DataMD5'}= $args{'Data'} ? md5_hex($args{'Data'}) : undef ;
        $this->{$Data} = $args{'Data'};
    }
    $this->{$DataMD5} = $args{'DataMD5'};
}

sub DoAuth {
    my ($this,$SecData) = @_;
    
    if (not ($this->{$DataMD5} or $SecData) or $this->{$DataMD5} eq md5_hex($SecData)) {
        if ($Strict) {
            $this->{$Data} = Security::Auth::GenSSID;
            $this->{$DataMD5} = md5_hex($this->{$Data});
        } else {
            $this->{$Data} = $SecData;
        }
        return Security::AUTH_SUCCESS;
    } else {
        return Security::AUTH_FAILED;
    }
}

sub SessionAuthData {
    my ($this) = @_;
    
    return $this->{$DataMD5};
}

sub ClientAuthData {
    my ($this) = @_;
    return $this->{$Data};
}

1;
