package IMPL::DOM::Schema::ComplexNode;
use strict;
use warnings;

use parent qw(IMPL::DOM::Schema::Node);
use IMPL::Class::Property;

BEGIN {
    public property content => {
        get => \&_getContent,
        set => \&_setContent
    }
}

our %CTOR = (
    'IMPL::DOM::Schema::Node' => sub {my %args = @_; $args{nodeName} ||= 'ComplexNode'; %args }
);

sub _getContent {
    $_[0]->firstChild;
}

sub _setContent {
    $_[0]->firstChild($_[1]);
}

sub Validate {
    my ($this,$node,$ctx) = @_;
    
    map $_->Validate($node,$ctx), @{$this->childNodes};
}

1;

__END__

=pod

=head1 DESCRIPTION

Описывает сложный узел. Требует либо соответствие структуры, либо соответствия
типу.

Дочерними элементами могут быть правила контроля свойств и т.п.
Первым дочерним элементом может быть только содержимое узла, см. C<content>

=head2 PROPERTIES

=over

=item C<content>

Содержимое узла, может быть либо C<IMPL::DOM::Schema::NodeSet> либо
C<IMPL::DOM::Schema::NodeList>, в зависимости от того важен порядок или нет.
Это свойство ссылается на первый дочерний элемент узла.

=back

=cut
