package Test::Web::View;
use IMPL::Profiler::Memory;
use strict;
use warnings;
use utf8;

use File::Slurp;
use Scalar::Util qw(weaken);
use Data::Dumper;
use IMPL::lang;
use IMPL::Test qw(assert assertarray test GetCallerSourceLine);

use IMPL::declare {
	require => {
		FormMeta => 'IMPL::Web::View::Metadata::FormMeta',
		ObjectMeta => 'IMPL::Web::View::Metadata::ObjectMeta',
		Schema => 'IMPL::DOM::Schema',
		Builder => 'IMPL::DOM::Navigator::Builder',
		Document => 'IMPL::DOM::Document',
		XMLReader => 'IMPL::DOM::XMLReader',
		MProfiler => '-IMPL::Profiler::Memory'
	},
	base => [
		'IMPL::Test::Unit' => '@_'
	]
};


sub AssertMemoryLeak {
    my $code = shift;
    my $dump = shift;
    
    my $data = MProfiler->Monitor($code);
    
    if ($data->isLeak and $dump) {
        write_file("dump.out", { binmode => ':utf8' }, $data->Dump() );
    }
    
    assert( not($data->isLeak), "Memory leak detected", GetCallerSourceLine()  , @{$data->{objects}} );    
}

sub templatesDir {
    shift->GetResourceDir('Resources','TTView');
}

test TestFormMetadata => sub {
	my ($this) = @_;
	
	# preload to avoid the false memory leak dection
	Schema->MetaSchema->Validate(Schema->MetaSchema);
	Document->Empty();
	require IMPL::DOM::Schema::Validator::RegExp;
	
	AssertMemoryLeak(sub{
		my ($doc,$errors) = XMLReader->LoadDocument(
			$this->GetResourceFile('Resources','person_info2.xml'),
			$this->GetResourceFile('Resources','person.schema.xml')
		);
		
		my $meta = FormMeta->new(
			$doc,
			$doc->schemaSource->type,
			{
				decl => $doc->schemaSource,
				schema => $doc->schema,
				errors => $errors
			}
		);
		
		assert(@{$errors||[]} == 2); 
	
		my $props = $meta->GetProperties;
		
		assertarray(
			[map $_->name, @$props],
			[qw(firstName lastName age address)]
		);
		assertarray(
			[map $_->modelType, @$props],
			[undef,undef,'number','ARRAY']
		);
		
		my $prop = $meta->GetProperty('address');
		
		assert($prop);
		assert($prop->schema->type eq 'address');
		assert($prop->isMultiple);
		
		assert(@{$prop->errors || []} == 1);
		assertarray(
			[map scalar(@{$_->errors || []}), @{$prop->GetItems}],
			[0,0,1]
		);
		
		my $item = $prop->GetItem(2);
		
		assert(@{$item->errors} == 1);		
		assert(@{$item->GetOwnErrors()} == 0);
				
		assert($item->GetProperty('street'));
		
		assert(@{$item->GetProperty('street')->errors} == 1);
		assert(@{$item->GetProperty('street')->GetOwnErrors()} == 1);
		
		#join ',', map $_->GetProperty('line')->name, @{$prop->GetItems};	
	});
};
test TestObjectMetadata => sub {
	my ($this) = @_;
	
	
};


1;