package IMPL::DOM::Schema::ValidationError;
use strict;
use warnings;

use overload
    '""' => \&toString,
    'fallback' => 1;

use base qw(IMPL::Object);
use IMPL::Class::Property;
use IMPL::Class::Property::Direct;
use IMPL::Resources::Format qw(FormatMessage);

BEGIN {
    public _direct property Node => prop_get; # target document node (if exists)
    public _direct property Schema => prop_get; # a schema for the target node (if exists) 
    public _direct property Source => prop_get; # a schema which triggered this error (can be equal to the Schema)
    public _direct property Parent => prop_get; 
    public _direct property Message => prop_get; # displayable message
}

sub CTOR {
    my ($this,%args) = @_;
    
    $this->{$Node} = $args{Node};
    $this->{$Schema} = $args{Schema} if $args{Schema};
    $this->{$Source} = $args{Source} if $args{Source};
    $this->{$Parent} = $args{Parent} if $args{Parent};
    $this->{$Message} = FormatMessage(delete $args{Message}, \%args) if $args{Message};
}

sub toString {
	(my $this) = @_;
	return $this->Message;
}

1;
