package Schema::DB::Constraint;
use Common;
our @ISA = qw(Object);

BEGIN {
    DeclareProperty Name => ACCESS_READ;
    DeclareProperty Table => ACCESS_READ;
    DeclareProperty Columns => ACCESS_READ;
}

sub CTOR {
    my ($this,%args) = @_;
    die new Exception("The table argument must be an instance of a table object") if not UNIVERSAL::isa($args{'Table'},'Schema::DB::Table');
    $this->{$Name} = $args{'Name'};
    $this->{$Table} = $args{'Table'};
    $this->{$Columns} = [map { ResolveColumn($this->Table,$_) } @{$args{'Columns'}}];
}

sub ResolveColumn {
    my ($Table,$Column) = @_;
    
    my $cn = UNIVERSAL::isa($Column,'Schema::DB::Column') ? $Column->Name : $Column;
    
    my $resolved = $Table->Column($cn);
    die new Exception("The column is not found in the table", $cn, $Table->Name) if not $resolved;
    return $resolved;
}

sub HasColumn {
    my ($this,@Columns) = @_;
    
    my %Columns = map { $_, 1} @Columns;
    
    return scalar(grep { $Columns{$_->Name} } $this->Columns) == scalar(@Columns);
}

sub UniqName {
    my ($this) = @_;
    return $this->{$Table}->Name.'_'.$this->{$Name};
}

sub Dispose {
    my ($this) = @_;
    
    delete @$this{$Table,$Columns};
    $this->SUPER::Dispose;
}
1;