package IMPL::DOM::Navigator::SchemaNavigator;
use strict;
use warnings;

use base qw(IMPL::DOM::Navigator);
use IMPL::Class::Property;
use IMPL::Class::Property::Direct;

__PACKAGE__->PassThroughArgs;

BEGIN {
    public _direct property Schema => prop_get;
}

sub CTOR {
    my ($this,$schema) = @_;
    
    $this->{$Schema} = $schema;
    
    die new IMPL::InvalidArgumentException("A schema object is required") unless $schema->isa('IMPL::DOM::Schema');
}

sub Navigate {
    my ($this,$query) = @_;
    
    if (my ($newNode) = $this->Current->selectNodes($query)) {
        if (ref $newNode eq 'IMPL::DOM::Schema::Node') {
            $newNode = $this->{$Schema}->ResolveType($newNode->type) || $newNode;
        }
        return $this->_NavigateNode($newNode);
    } else {
        return undef;
    }
}

1;
__END__

=pod

=head1 DESCRIPTION

  ,    ,      <Node nodeName="SomeName" type="ReferencedType"/>.
             .

=cut