package Test::DOM::Navigator;
use base qw(IMPL::Test::Unit);

__PACKAGE__->PassThroughArgs;

use IMPL::Test qw(test failed);
use IMPL::DOM::Navigator;
use IMPL::DOM::Node;

test Creation => sub {
    my ($this) = @_;
    
    my $doc = new IMPL::DOM::Node(nodeName => 'root');
    
    my $obj = new IMPL::DOM::Navigator($doc) or failed "Failed to create instance" ;
};

test Navigate => sub {
    my $doc = new IMPL::DOM::Node(nodeName => 'root');
    my $child = $doc->insertNode(
        new IMPL::DOM::Node(
            nodeName => 'Child'
        )
    );
    
    my $navi = new IMPL::DOM::Navigator($doc);
    my $navresult = $navi->Navigate("Child");
    
    failed ("Navigate retuned unexpected result", "Recieved: $navresult", "Expected: $child") if $child != $navresult;
    my $curr = $navi->Current;
    failed ("Current node has a wrong value","Current: $curr","Expected: $child") if $child != $curr;
};

test PathToString => sub {
    my $doc = new IMPL::DOM::Node(nodeName => 'root');
    my $child = $doc->insertNode(
        new IMPL::DOM::Node(
            nodeName => 'Child'
        )
    );
    
    my $navi = new IMPL::DOM::Navigator($doc);
    $navi->Navigate("Child");
    
    my $expected = "root/Child";
    my $res = $navi->PathToString;
    failed("Unexpected PathToString result","Recieved: $res","Expected: $expected") if $res ne $expected;
};

test Back => sub {
    my $doc = new IMPL::DOM::Node(nodeName => 'root');
    my $child = $doc->insertNode(
        new IMPL::DOM::Node(
            nodeName => 'Child'
        )
    );
    
    my $navi = new IMPL::DOM::Navigator($doc);
    $navi->Navigate("Child");
    my $navresult = $navi->Back;
    
    failed ("Back() retuned unexpected result", "Recieved: $navresult", "Expected: $doc") if $doc != $navresult;
    my $curr = $navi->Current;
    failed ("Current node has a wrong value","Current: $curr","Expected: $doc") if $doc != $curr;
};





1;
