package IMPL::DOM::Schema::SimpleNode;
use strict;
use warnings;

use parent qw(IMPL::DOM::Schema::Node);
use IMPL::Class::Property;
use IMPL::Class::Property::Direct;
use IMPL::DOM::Property qw(_dom);

BEGIN {
    public _dom _direct property inflator => prop_get;
    public _dom _direct property messageInflateError => prop_get;
}

our %CTOR = (
    'IMPL::DOM::Schema::Node' => sub {
        my %args = @_;
        $args{nodeName} ||= 'SimpleNode';
        delete @args{qw(inflator messageInflateError)};
        %args
    }
);

sub CTOR {
    my ($this,%args) = @_;
    
    if ( $args{inflator} ) {
        $this->{$inflator} = $args{inflator} ;
        $this->{$messageInflateError} = exists $args{messageInflateError} ? $args{messageInflateError} : 'Failed to inflate nodeValue %node.path%: %error%';
    }
}

sub Validate {
    my ($this,$node,$ctx) = @_;
    
    my @result;
    
    push @result, $_->Validate($node,$ctx) foreach $this->childNodes;
    
    return @result;
}

sub inflateValue {
    my ($this,$value) = @_;
    
    if ( my $inflator = $this->inflator ) {
        return $inflator->new($value,$this);
    } else {
        return $value;
    }
}

1;

__END__

=pod

=head1 NAME

C<IMPL::DOM::SimpleNode> - узел с текстом.

=head1 DESCRIPTION

Узел имеющий простое значение. Данный узел может содержать ограничения
на простое значение.

Производит валидацию содержимого, при постоении DOM модели не имеет специального
типа и будет создан в виде C<IMPL::DOM::Node>.

Также определяет как будет воссоздано значение узла в DOM модели.

=cut
