package Test::SQL::Diff;
use strict;
use warnings;
use parent qw(IMPL::Test::Unit);

use IMPL::Test qw(test failed assert);
use IMPL::SQL::Schema();
use IMPL::SQL::Types qw(Integer Varchar Text);
use IMPL::SQL::Schema::Traits::Diff();
use Data::Dumper;

__PACKAGE__->PassThroughArgs;

test diff => sub {
    my $schemaSrc = new IMPL::SQL::Schema(name => 'simple', version => 1 );
    
    my $tbl = $schemaSrc->AddTable({
        name => 'User',
        columns => [
            { name => 'name', type => Varchar(255) },
            { name => 'description', type => Varchar(255) }
        ]
    });
    
    $tbl->AddConstraint( unique => { name => 'unique_name', columns => ['name'] });
    
    my $schemaDst = new IMPL::SQL::Schema(name => 'simple', version => 2 );
    
    my $users = $schemaDst->AddTable({
        name => 'User',
        columns => [
            { name => 'id', type => Integer },
            { name => 'login', type => Varchar(255) },
            { name => 'description', type => Text, isNullable => 1 }
        ]
    });
    
    $users->SetPrimaryKey('id');
    $users->AddConstraint( unique => { name => 'unique_login', columns => ['login'] } );
    
    #warn Dumper(IMPL::SQL::Schema::Traits::Diff->Diff($schemaSrc,$schemaDst));
    
    $schemaSrc->Dispose;
    $schemaDst->Dispose;
    
};


1;
