package IMPL::Web::View::Metadata::FormMeta;
use strict;

use IMPL::Const qw(:prop);
use IMPL::declare {
	require => {
		Exception => 'IMPL::Exception',
		ArgException => '-IMPL::InvalidArgumentException'
	},
	base => [
		'IMPL::Web::View::Metadata::BaseMeta' => '@_'
	],
	props => [
		decl => PROP_RO,
		schema => PROP_RO,
		nodes => PROP_RO,
		errors => PROP_RO
	]
};

sub CTOR {
	my ($this,$provider,$model,$type,$args) = @_;
	
	if ($args) {
		$this->$_($args->{$_}) foreach grep $args->{$_}, qw(decl schema nodes errors);
	}
	
	$this->$_() || die ArgException->new($_ => "The $_ is required")
		foreach qw(decl schema);
}

sub GetOwnErrors {
	
}


1;

__END__

=pod

=head1 NAME

=head1 SYNOPSIS

=head1 DESCRIPTION

Метаданные по модели, являющейся частью формы. Элемент формы описывается
несколькими компонентами:

=over

=item * schema

Схема текущего элемента, СomlexType, SimpleType, ComplexNode или SimpleNode

=item * decl

Сам элемент формы, который присутствует в родительском контейнере. Объявление
может совпадать со схемой в случае, когда это был SimpleNode или ComplexNode,
иначе это Node ссылающийся на заранее обпределенный тип.

=item * nodes

Список узлов документа, которые являются экземплярами текущего элемента, в
случае, если этот элемен не является множественным (maxOccur=1), тогда здесь
должен быть только один элемент.

=item * errors

Список ошибок относящихся к данному элементу.

=back 

=cut