package IMPL::Web::View::Metadata::BaseMeta;
use strict;

use IMPL::lang;
use IMPL::Const qw(:prop);
use IMPL::declare {
	require => {
		Exception => 'IMPL::Exception',
		ArgException => '-IMPL::InvalidArgumentException'
	},
	base => [
		'IMPL::Object' => undef
	],
	props => [
		model => PROP_RO,
		modelType => PROP_RO,
		provider => PROP_RO,
		name => PROP_RO,
		label => PROP_RO,
		container => PROP_RO,
		template => PROP_RO,
		
		_childMap => PROP_RO,
		_childNames => PROP_RO
	]
};

sub CTOR {
	my ($this,$provider,$model,$type,$args) = @_;
	
	$type ||= typeof($model);
	
	die ArgException->new(provider => 'A provider must be specified');
	
	$this->provider($provider);
	$this->model($model);
	$this->modelType($type);
	$this->childMap({});
	
	#mixin other args
	if ($args) {
		$this->$_($args->{$_}) foreach grep $args->{$_}, qw(name label container template);
	}
}

sub GetChild {
	my ($this,$name) = @_;
	
	if(my $child = $this->_childMap->{$name}) {
		return $child;
	} else {
		return $this->_childMap->{$name} = $this->provider->GetChild($this,$name);
	}
}

sub GetChildren {
	my ($this) = @_;
	
	if ($this->_childNames) {
		return [ map $this->_childMap->{$_}, @{$this->_childNames} ];
	} else {
		my @childNames;
		my %childMap;
		my @result; 
	
		foreach my $child (@{$this->provider->PopulateChildren($this)}) {
			$childMap{$child->name} = $child;
			push @childNames, $child->name;
			push @result, $child;
		}
		
		$this->_childMap(\%childMap);
		$this->_childNames(\@childNames);
		return \@result;
	}	
}

1;

__END__

=pod

=head1 NAME

=head1 SYNOPSIS

=head1 DESCRIPTION

Метаданные описывают модель, ее свойства, используются для построения
представления.

=over

=item * type

Опционально. Тип модели. В случаях, когда модель не определена, данное свойство
позволяет определить ее тип.

=item * label

Опционально. Имя модели для отображения.

=item * template

Шаблон, который следует использовать для отображения модели.

=item * fields

Коллекция с информацией по свойствам (полям) модели. Данный хеш используется
для определения представления при использовании C<display_for('field')>.

=back

Метаданные публикуются провайдером, кроме того они могут быть расширены
дополнительными свойствами.

=head1 MEMBERS

=head2 C<GetChild($name)>

Возвращает метаданные для дочернего элемента, например свойства объекта

=head2 C<GetChildren()>

Возвращает ссылку на массив с метаданными для дочерних элементов

=cut