package IMPL::Class::Property;
use strict;
use parent qw(Exporter);

BEGIN {
    our @EXPORT = qw(property prop_get prop_set owner_set prop_none prop_all prop_list CreateProperty);
}

use IMPL::lang qw(:hash);
use IMPL::Const qw(:prop);
use Carp qw(carp);
require IMPL::Class::Member;

sub import {
    __PACKAGE__->export_to_level(1,@_);
    IMPL::Class::Member->export_to_level(1,@_);
}

sub prop_get { 1 };
sub prop_set { 2 };
sub owner_set { 10 };
sub prop_none { 0 };
sub prop_all { 3 };
sub prop_list { 4 };

sub property($$) {
    my ($propName,$attributes) = @_;
    
    my $class = caller;
    
    return hashMerge (
        $class->ClassPropertyImplementor->NormalizeSpecification($attributes),
	    {
	        implementor => $class->ClassPropertyImplementor,
	    	name => $propName,
	    	class => scalar(caller),
	    }
    );
}

sub CreateProperty {
    my ($class,$propName,@attributes) = @_;
    
    $class
        ->ClassPropertyImplementor
        ->Implement(
            @attributes,
            {
                name => $propName,
                class => $class,
            }
        );
};

1;
