package IMPL::DOM::PostToDOM;
use strict;
use warnings;

use IMPL::DOM::Navigator;
use IMPL::Class::Property;

use base qw(IMPL::Transform);

BEGIN {
    public property documentClass => prop_get | owner_set;
    public property documentSchema => prop_get | owner_set;
    private property _navi => prop_all;
}

our %CTOR = (
    'IMPL::Transform' => sub {
        HASH => \&TransfromPostData
    }
);

sub CTOR {
	my ($this,$docClass,$docSchema) = @_;
	$docClass ||= 'IMPL::DOM::Document'
}

sub TransformPostData {
    my ($this,$data) = @_;
    
    my $navi = $this->Navigator;
    
    while (my ($key,$value) = each %$data) {
    	# TODO: review
        my $node = $navi->Navigate(split /\//, $key);
        $node->nodeValue($value);
    }
    
    return $navi->Document;
}

package IMPL::DOM::PostToDOM::Navigator;
use base qw(IMPL::DOM::Navigator::Builder);

__PACKAGE__->PassThroughArgs;

sub Navigate {
	my ($this,@path) = @_;
	
	if (@path > 1) {
		my $node;
		foreach my $query (@path) {
			unless($this->dosafe(sub {
				$node = $this->SUPER::Navigate($query);
			})) {
				$node = $this->NavigateCreate($query);				
			}
		}
	} else {
		die new IMPL::InvalidArgumentException("A path is a required parameter");
	}
}

1;
