package IMPL::Web::Exception;
use strict;
use warnings;

use parent qw(IMPL::Exception);

__PACKAGE__->PassThroughArgs;

sub code {
	400;
}

1;

__END__

=pod

=head1 NAME

C<IMPL::Web::Exception> - Базовый класс для всех web-исключений, для ошибок вызванных
по вине клиента.

=head1 SYNOPSIS

Вызов исключения

=begin code

use IMPL::require {
	WebException => 'IMPL::Web::WebException'
};

sub MyWebHandler {
	# ...
	
	die WebException->new("something is wrong"); 
	
	# ...	
}

=end code

=head1 MEMBERS

=head2 C<code()>

Возвращает C<HTTP> код ошибки. Каждый класс иключений должен переопределить данный метод.

=cut