package IMPL::Web::CGIApplication;
use strict;

use IMPL::Const qw(:prop);
use IMPL::declare {
    require => {
        CGIWrapper => 'IMPL::Web::CGIWrapper'        
    },
    base => [
        'IMPL::Web::Application' => '@_'
    ],
    props => [
        _queryFetched => PROP_RW
    ]
};

sub CTOR {
    my ($this) = @_;
    
    $this->output(\*STDOUT) unless $this->output;
}

sub FetchRequest {
    my ($this) = @_;
    
    return if $this->_queryFetched;
    
    my $query = CGIWrapper->new();
    
    $query->charset($this->requestCharset) if $this->requestCharset;
    
    $this->_queryFetched(1);
    
    return $query;
}

1;