package IMPL::Object::AutoDispose;
use strict;

use IMPL::declare {
    base => [
        'IMPL::Object::Abstract' => undef
    ]
};

sub new {
    my $self = shift;
        
    if (ref $self) {
        return ${$self}->new(@_);
    } else {
        my $obj = shift;
        return bless \$obj, $self;        
    }    
}

sub isa {
    ${shift(@_)}->isa(@_);
}

sub can {
    ${shift(@_)}->can(@_);
}

sub DTOR {
    ${shift(@_)}->Dispose();
}

sub typeof {
    ${shift(@_)}->typeof(@_);
}

sub toString {
    ${shift(@_)}->toString(@_);
}

sub AUTOLOAD {
    our $AUTOLOAD;
    my ($method) = ($AUTOLOAD =~ m/(\w+)$/);
    
    no strict 'refs';
    
    goto &{*{$AUTOLOAD} = sub {
        ${shift(@_)}->$method(@_);
    }};
}

1;