package IMPL::Object;
use strict;

use parent qw(IMPL::Object::Abstract);

sub surrogate {
    bless {}, ref $_[0] || $_[0];
}

sub new {
    my $class = shift;
    my $self = bless {}, ref($class) || $class;    
    $self->callCTOR(@_);
  
    $self;
}

sub _PropertyImplementor {
    'IMPL::Class::Property::Direct'
}

1;

__END__

=pod

=head1 SINOPSYS

=begin code

package Foo;
use parent qw(IMPL::Object);

sub CTOR {
    my ($this,$arg) = @_;
    print "Foo: $arg\n";
}

package Bar;
use parent qw(IMPL::Object);

sub CTOR {
    my ($this,$arg) = @_;
    print "Bar: $arg\n";
}

package Baz;
use parent qw(Foo Bar);

our %CTOR = (
    Foo => sub { my %args = @_; $args{Mazzi}; },
    Bar => sub { my %args = @_; $args{Fugi}; }
);

package Composite;
use parent qw(Baz Foo Bar);

our %CTOR = (
    Foo => undef,
    Bar => undef
);

sub CTOR {
    my ($this,%args) = @_;
    
    print "Composite: $args{Text}\n";
}

package main;

my $obj = new Composite(
    Text => 'Hello World!',
    Mazzi => 'Mazzi',
    Fugi => 'Fugi'
);

# will print
#
# Foo: Mazzi
# Bar: Fugi
# Bar:
# Composite: Hello World!

=end code

=head1 Description

   ,   .

=head1 Members

=over

=item operator C<new>(@args)

        @args.

=item operator C<surrogate>()

   .

=back

=head1 Cavearts

 ,   C<use parent>    ,    
 C<Composite>   C<Baz>,   C<Foo>,   
C<Foo>        C<Baz>.   :)

=cut
