package Test::Lang;
use strict;
use warnings;

use parent qw(IMPL::Test::Unit);

use IMPL::Test qw(test failed assert);
use IMPL::lang qw(:hash :compare clone);

__PACKAGE__->PassThroughArgs;

test equals => sub {
	assert( equals(1,1) );
	assert( !equals(1,2) );
	
	{
		my $warns = 0;
		local $SIG{__WARN__} = sub { $warns++ };
		
		assert( !equals("1","2") );
		assert( equals("sfds","zxcvgfd") );
		assert( $warns == 2);
	}
	
	assert( equals(undef,undef) );
	assert( !equals(1,undef) );
	assert( !equals(undef,"zcx") );
};

test equals_s => sub {
	assert( equals_s(1,1) );
	assert( !equals_s(1,2) );
	
	assert( !equals_s("1","2") );
	assert( !equals_s("sfds","zxcvgfd") );
	
	assert( equals_s(undef,undef) );
	assert( !equals_s(1,undef) );
	assert( !equals_s(undef,"zcx") );
	
	assert( equals_s("qwerty","qwerty") );
};

test hash => sub {
	
	my %a = (
		a => 'a',
		b => 'b',
		c => 'c'
	);
	
	my %b = (
		a => 'a',
		c => 'z',
		x => 'x',
	);
	
	my %diff = (
		'-b' => 1,
		'+c' => 'z',
		'+x' => 'x'
	);
	
	
	assert( ! hashCompare(\%a,\%b)  );
	assert( hashCompare(\%a,\%a) );
	
	my $res = hashDiff(\%a,\%b);
	
	assert( ! hashCompare({},$res) );
	assert( hashCompare($res,\%diff) );
	
	assert( hashCompare( \%b, hashMerge(\%a,\%diff) ) );
	
};

test clone => sub {
	
	my $a;
	
	my $b = clone($a);
	
	assert(not defined $b);
	
	my $lp = { a => '1' };
	$lp->{b} = $lp;
	
	my $c = clone($lp); 
	
	assert($c);
	assert($c->{b});
	assert($c->{b} == $c);
	
};

1;