package Form::ItemId;
use strict;
use Common;
our @ISA = qw(Object);

BEGIN {
    DeclareProperty Name => ACCESS_READ;
    DeclareProperty Canonical => ACCESS_READ;
    DeclareProperty InstanceID => ACCESS_READ;
    DeclareProperty Parent => ACCESS_READ;
}

sub CTOR {
    my ($this,$name,$instance_id,$parent) = @_;
    
    $this->{$Name} = $name or die new Exception('A name is required for the item id');
    $this->{$InstanceID} = $instance_id;
    $this->{$Parent} = $parent;
    
    $this->{$Canonical} = ($parent && !$parent->isa('Form::ItemId::Root') ? $parent->Canonical.'/':'').$name.(defined $instance_id ? $instance_id : '');
}

sub ToNAVPath {
    my ($this) = @_;
    
    return ($this->{$Parent} ? ($this->{$Parent}->ToNAVPath,$this) : $this);
}

package Form::ItemId::Prev;
our @ISA = qw(Form::ItemId);

sub CTOR {
    my ($this,$parent) = @_;
    $this->SUPER::CTOR('(prev)',undef,$parent);
}

package Form::ItemId::Root;
our @ISA = qw(Form::ItemId);

sub CTOR {
    my ($this,$parent) = @_;
    $this->SUPER::CTOR('(root)',undef,$parent);
}


1;
