package IMPL::Class::Member;
use strict;
use parent qw(Exporter);
our @EXPORT = qw(&public &private &protected &_direct);


use IMPL::Const qw(:access);

require IMPL::Class::MemberInfo;

sub public($) {
	my $info = shift;
    $info->{access} = ACCESS_PUBLIC;
    my $implementor = delete $info->{implementor};
    $implementor->Implement($info);
}

sub private($) {
    my $info = shift;
    $info->{access} = ACCESS_PRIVATE;
    my $implementor = delete $info->{implementor};
    $implementor->Implement($info);
}

sub protected($) {
    my $info = shift;
    $info->{access} = ACCESS_PROTECTED;
    my $implementor = delete $info->{implementor};
    $implementor->Implement($info);
}

sub _direct($) {
    my $info = shift;
    $info->{direct} = 1;
    return $info;
}

1;
