package IMPL::Web::View::Metadata::FormMeta;
use strict;

use IMPL::Const qw(:prop);
use IMPL::declare {
	require => {
		Exception => 'IMPL::Exception',
		ArgException => '-IMPL::InvalidArgumentException'
	},
	base => [
		'IMPL::Web::View::Metadata::BaseMeta' => '@_'
	],
	props => [
		nodes => PROP_RO,
		decl  => PROP_RO,
		schema => PROP_RO,
		errors => PROP_RO
	]
};

sub CTOR {
	my ($this,$provider,$model,$type,$args) = @_;
	
	if ($args) {
		$this->$_($args->{$_}) foreach grep $args->{$_}, qw(decl schema nodes errors);
	}
	
	$this->$_() || die ArgException->new($_ => "The $_ is required")
		foreach qw(decl schema);
}

sub isMultiple {
	shift->decl->isMultiple;
}

sub isOptional {
	shift->decl->isOptional;
}

sub GetOwnErrors {
	my ($this) = @_;
	
	my $node = undef;
	
	$node = not($this->isMultiple) && $this->nodes ? $this->nodes->[0] : undef;
	
	return [
		grep {
			($node && $_->node && $_->node == $node) || (not($node) && $_->schema == $this->decl )
		} @{$this->errors || []}
	];
}

1;

__END__

=pod

=head1 NAME

=head1 SYNOPSIS

=head1 DESCRIPTION

Расширенные метаданные модели для элементов формы, помимо стандартных свойств
сожержит в себе информацию о схеме.

=head1 MEMBERS

=head2 C<[get]errors>

Ссылка на массив с ошибками при проверке схемы. Ошибки относятся ко всем
узлам в текущей модели, включая вложенные и т.п.

=head2 C<[get]model>

Ссылка на элемент документа, либо на массив с элементами для множественных
значений (C<isMultiple = true>). В том случае, когда документ был не
корректен и для не множественного элемента было передено несколько значений,
данное свойство будет содержать только первое.

=head2 C<[get]nodes>

Ссылка на массив с узлами документа. В теории количество узлов может быть
произвольным, поскольку документ может быть некорректным, т.е. их может
быть более одного в то время, как C<isMultiple = false> или, напротив, ни
одного при C<isOptional = false>.

Как правило для построения формы данное свойство не требуется.

=head2 C<[get]modelType>

Название типа данных из схемы документа (C<< schema->name >>), если тип не имеет название, то это
C<ComplexNode> для сложных узлов и C<SimpleNode> для простых.

Для моделей с множественными значениями это свойство не задано. Тип элементов
храниться в свойстве C<holdingType>

=head2 C<[get]decl>

Объявление элемента формы, объявление может совпадать со схемой в случае,
когда это был C<SimpleNode> или C<ComplexNode>, иначе это C<Node> ссылающийся
на заранее обпределенный тип.

=head2 C<[get]schema>

Схема текущего элемента, C<СomlexType>, C<SimpleType>, C<ComplexNode> или
C<SimpleNode>.

=head2 C<[get]isOptional>

Данный элемент может не иметь ни одного значения

=head2 C<[get]isMultiple>

Данный элемент может иметь более одного значения. Модель с множественными
значениями является сложным элементом, в котором дочерними моделями являются
не свойства а сами элементы, в данном случае они их именами будут индексы.

=begin code

for(my $i=0; $i< 10; $i++) {
	display_for($i,'template');
}

sub display_for {
	my ($index,$tmpl) = @_;
	
	if ($index =~ /^\d+$/) {
		return render($tmpl, meta => { $meta->GetItem($index) });
	} else {
		return render($tmpl, meta => { $meta->GetProperty($index) });
	}
}

=end code

=head2 C<GetOwnErrors()>

Возвращает ошибки относящиеся к самому элементу C<model>, это принципиально
для контейнеров и в случаях, когда модель не корректна и в ней присутствуют
лишние значения.  

=cut