package IMPL::Web::View::Metadata::ObjectProvider;
use strict;

use IMPL::lang;
use IMPL::declare {
	require => {
		Exception => 'IMPL::Exception',
		ArgException => '-IMPL::InvalidArgumentException',
		Meta => 'IMPL::Web::View::Metadata',
		PropertyInfo => 'IMPL::Class::PropertyInfo'
	},
	base => [
		'IMPL::Object' => undef
	]
};

sub GetMetadata {
	my ($this,$model) = @_;
	
	my $class = typeof($model) || $model;
		
	return Meta->new(
		type => $class,
		provider => $this
	);
}

# returns array of metadata
sub GetFields {
	my ($this,$class) = @_;
	
	my %seen;
	
	return map {
		my %meta = (
			provider => $this
		);
		
		$meta{type} = $_->type if $_->type;
		
		# TODO extend from metadata and external providers
		
		return Meta->new(%meta);
	} $class->GetMeta(PropertyInfo, sub { $seen{$_->name} ? 0 : ($seen{$_->name} = 1) } , 1); 
	
}

1;