package IMPL::DOM::Schema::Item;
use strict;
use warnings;

use base qw(IMPL::DOM::Node);
use IMPL::Class::Property;
use IMPL::DOM::Property qw(_dom);
use IMPL::Class::Property::Direct;

BEGIN {
    public _dom property minOccur => prop_all;
    public _dom property maxOccur => prop_all;
    public _direct property Schema => prop_get;
}

__PACKAGE__->PassThroughArgs;

sub CTOR {
    my ($this,%args) = @_;
    
    $this->minOccur($args{minOcuur});
    $this->maxOccur($args{maxOccur});
    $this->{$Schema} = $args{Schema} or die new IMPL::InvalidArgumentException("A schema should be specified");
}

1;

__END__
=pod

=head1 SYNOPSIS

package Restriction;
use base qw(IMPL::DOM::Schema::Item);

sub Validate {
    my ($this,$node) = @_;
}

=head1 DESCRIPTION

    .      

=cut
