package IMPL::DOM::Navigator::Builder;
use strict;
use warnings;

use base qw(IMPL::DOM::Navigator);

use IMPL::Class::Property;

BEGIN {
    public property SchemaNavigator => prop_get | owner_set;
}

1;

=pod

=head1 SYNOPSIS

my $nav = new IMPL::DOM::Navigator::Builder(Schema => $mySchema);

# set position to root
$nav->InitRoot();

# go to node 'Person' and create one if not exists
$nav->NavigateAuto("Person");

# set some node properties
$nav->nodeCurrent->Name("Smith");
$nav->nodeCurrent->Age("20");

# navigate to node 'Address' and create one if not exists
$nav->NavigateAuto("Address");

=head1 DESCRIPTION

,        

=cut