package IMPL::SQL::Schema::Constraint::PrimaryKey;
use strict;
use parent qw(IMPL::SQL::Schema::Constraint::Index);
use IMPL::Class::Property;

__PACKAGE__->PassThroughArgs;
__PACKAGE__->RegisterAlias('pk');

BEGIN {
    public _direct property connectedFK => prop_get;
}

sub CTOR {
    my ($this,%args) = @_;
    
    $this->{$connectedFK} = {};
}

sub ConnectFK {
    my ($this,$FK) = @_;
    
    UNIVERSAL::isa($FK,'IMPL::SQL::Schema::Constraint::ForeignKey') or die new Exception('Aprimary key could be connected only to a foreign key');
    not exists $this->{$connectedFK}->{$FK->uniqName} or die new Exception('This primary key already conneted with the specified foreing key',$FK->name,$FK->table->name);
    
    $this->{$connectedFK}->{$FK->uniqName} = $FK;
}

sub DisconnectFK {
    my ($this,$FK) = @_;
    
    delete $this->{$connectedFK}->{$FK->uniqName};
}

sub Dispose {
    my ($this) = @_;
    
    delete $this->{$connectedFK};
    
    $this->SUPER::Dispose;
}

1;
