package IMPL::DOM::Schema::Label;
use strict;
use overload
	'""' => 'ToString',
    'bool'     =>   sub { return 1; },
    'fallback' => 1;

use IMPL::Const qw(:prop);
use IMPL::Exception();
use IMPL::declare {
	require => {
		ArgException => '-IMPL::InvalidArgumentException'
	},
	base => [
		'IMPL::Object' => undef
	],
	props => [
		_map => PROP_RW,
		_id => PROP_RW
	]
};

sub CTOR {
	my ($this,$map,$id) = @_;
	
	die ArgException->new('map' => 'A strings map is required')
		unless $map;
	die ArgException->new('id' => 'A lable identifier is required')
		unless $id;
}

our $AUTOLOAD;
sub AUTOLOAD {
	my ($this) = @_;
	
	my ($method) = ($AUTOLOAD =~ /(\w+)$/);
	return
		if $method eq 'DESTROY';
		
	return $this->new($this->_map,$method);
}

sub ToString {
	my ($this) = @_;
	return $this->_map->GetString($this->_id);
}

1;