package IMPL::Web::Security;

use base qw(IMPL::Object IMPL::Security IMPL::Object::Autofill);

use IMPL::Class::Property;

__PACKAGE__->PassThroughArgs;

BEGIN {
	public property sessionFactory => prop_get | owner_set;
	public property userFactory => prop_get | owner_set; 
}

sub CTOR {
	my ($this) = @_;
	
	$this->dataSource or die new IMPL::InvalidArgumentException("The argument is required",'dataSource');
}

sub Session {
	my ($this,%args) = @_;
}

sub User {
	
}

1;

__END__

=pod

=head1 NAME

C<IMPL::Web::Security>       .

=head1 SINOPSYS

=begin code xml

<security type='IMPL::Config::Activator'>
	<factory>IMPL::Web::Security</factory>
	<parameters type='HASH'>
		<sessionFactory type='IMPL::Object::Factory'>
			<factory type='IMPL::Object::Factory'>App::Data::Session</factory>
			<method>insert</method>
		</sessionFactory>
	</parameters>
</security>

=end code xml

=head1 DESCRIPTION

      .  
  ,       ,  
    .      
  .      
 .

C<IMPL::Web::Session>        
.      ,  
   .

C<IMPL::Web::User> ,     
C<IMPL::Security::Principal>,        
 C<IMPL::Security::Auth>.

=head1 MEMBERS

=cut