package IMPL::DOM::Schema::SwitchNode;
use strict;
use warnings;

use IMPL::declare {
	require => {
		Label => 'IMPL::DOM::Schema::Label',
		ValidationError => 'IMPL::DOM::Schema::ValidationError'
	},
	base => [
		'IMPL::DOM::Schema::AnyNode' => sub {
	        my %args = @_;
	        
	        $args{nodeName} ||= 'SwitchNode';
	        
	        %args;
	    }
	],
	props => [
		messageNoMatch => { get => 1, set => 1, dom => 1 } 
	]
};

sub CTOR {
    my ($this,%args) = @_;
    
    $this->messageNoMatch($args{messageNoMatch} || 'A node %node.nodeName% isn\'t expected in the %parent.path%');
}

sub Validate {
    my ($this,$node,$ctx) = @_;
        
    if ( my ($schema) = $this->selectNodes(sub {$_[0]->name eq $node->nodeName} ) ) {
        return $schema->Validate($node,$ctx);
    } else {
        return ValidationError->new(
            node => $node,
            message => $this->_MakeLabel($this->messageNoMatch)
        );
    }
}

sub _MakeLabel {
	my ($this,$label) = @_;
	
	if ($label =~ /^ID:(\w+)$/) {
		return Label->new($this->document->stringMap, $1);
	} else {
		return $label;
	}
}

1;

__END__

=pod

=head1 DESCRIPTION

Представляет узел, который может быть одним из узлов, которые лежат внутри него.
Это более строгий вариант C<IMPL::DOM::Schema::AnyNode>.

=cut
