package IMPL::Security::Context;
use strict;
use warnings;

use base qw(IMPL::Object);

use IMPL::Class::Property;

require IMPL::Security::Principal;

my $current;
my $nobody;

BEGIN {
    public property Principal => prop_get;
    public property AssignedRoles => prop_all | prop_list;
    public property AuthSession => prop_all;
}

sub Impersonate {
    my ($this,$code) = @_;
    
    my $old = $current;
    my $result;
    local $@;
    eval {
        $result = $code->();
    };
    $current = $old;
    if($@) {
        die $@;
    } else {
        return $result;
    }
}

sub contextNobody {
    my ($self) = @_;
    $nobody = $self->new(Principal => IMPL::Security::Principal->nobody, AssignedRoles => undef) unless $nobody;
    $nobody;
}

sub contextCurrent {
	my ($self) = @_;
	
	$current = __PACKAGE__->nobody unless $current;
	$current;
}

1;
