package IMPL::Object::Meta;
use strict;
use warnings;

use parent qw(IMPL::Object);
use IMPL::Class::Property;
use IMPL::Class::Property::Direct;

BEGIN {
    public _direct property Container => prop_get | owner_set;
}

sub meta {
    my $class = shift;
    my $caller = caller;
    my $meta = $class->surrogate();
    $meta->IMPL::Object::Meta::Container(scalar caller);
    $meta->callCTOR(@_);
    $caller->set_meta($meta);
}

1;

__END__

=pod

=head1 SYNOPSIS

package Foo;

meta BarAttribute('Simple bar attribute'); #mark Foo with BarAttribute

=head1 DESCRIPTION

Базовый класс для мета-свойств класса. Определяет оператор C< meta > для создания метаданных в вызвавшем классе.

=head1 MEMBERS

=over

=item C< Container >

Свойство заполняется до вызова конструктора и содержит имя модуля к которому применяется атрибут.

=back

=cut
