package Test::SQL::Traits;
use parent qw(IMPL::Test::Unit);

__PACKAGE__->PassThroughArgs;

use IMPL::lang;
use IMPL::Class::Property;
use IMPL::Test qw(test failed shared assert);

use IMPL::SQL::Schema;
use IMPL::SQL::Schema::Traits;
use IMPL::SQL::Types qw(Integer Varchar DateTime);

BEGIN {
    shared public property schema => prop_all; 
}

sub StartUnit {
    return {
        schema => new IMPL::SQL::Schema( name => 'testTraits', version => 1 )
    };
}

test CreateTable => sub {
    my ($this) = @_;
    
    my $table = $this->schema->AddTable(
        new IMPL::SQL::Schema::Traits::Table(
            'user'
        )
    ) or failed "Failed to create table";
    
    $this->schema->GetTable('user') or failed "Can't get a created table";
    
};

test InsertColumn => sub {
    my ($this) = @_;
    
    my $table = $this->schema->GetTable('user');
    
    $table->InsertColumn(
        new IMPL::SQL::Schema::Traits::Column(
            id => Integer, tag => { auto_increment => 1 }
        )
    );
    
    my $column = $table->GetColumn('id') or failed "Column not found";
    
    assert( $column->name eq 'id');
    assert( $column->type->SameValue(Integer()) );
    assert( not $column->isNullable );
    assert( $column->tag->{auto_increment} );
    
    $table->InsertColumn(
        new IMPL::SQL::Schema::Traits::Column(
            name => Varchar(255), isNullable => 1
        )
    );
    
    $column = $table->GetColumn('name');
    
    assert($column);
    assert($column->name eq 'name');
    assert($column->type->SameValue(Varchar(255)));
    assert($column->isNullable);
};

test CreateTableWithColumns => sub {
    my ($this) = @_;
    
    my $table = $this->schema->AddTable(
        new IMPL::SQL::Schema::Traits::Table(
            session => [
                new IMPL::SQL::Schema::Traits::Column( id => Varchar(64)),
                new IMPL::SQL::Schema::Traits::Column( expires => DateTime ),
                new IMPL::SQL::Schema::Traits::Column( role => Varchar(64), defaultValue => 'user' )
            ]
        )
    ) or failed "Failed to create table";
    
    assert( $table->ColumnsCount == 3 );
    
    assert( my $column = $table->GetColumn('id') );
    assert($column->type->SameValue(Varchar(64)));
    assert(not $column->isNullable);
    
    assert( $column = $table->GetColumn('role') );
    assert( $column->defaultValue eq 'user' );
};

sub FinishUnit {
    my ($self,$session) = @_;
    
    $self->supercall::FinishUnit();
    
    $session->{schema}->Dispose();
}

1;
