package IMPL::Text::Schema;
use strict;
use warnings;

use parent qw(IMPL::DOM::Schema);

__PACKAGE__->PassThroughArgs;

1;

__END__

=pod

=head1 SINOPSYS

<schema>
    <ComplexNode name="syntax">
        <Node name="Define" type="Statement" minOccur="1" maxOccur="unbounded">
            <Property name="name" type="Word"/>
        </Node>
    </ComplexNode>
    <ComplexType type="Statement" nativeType="IMPL::Text::Schema::Statement">
        <NodeList>
            <SwitchNode minOccur="1" maxOccur="unbounded">
                <Node name="Word" type="Word"/>
                <Node name="Statement" type="Word"/>
                <Node name="Regexp" type="Regexp"/>
                <Node name="Switch" type="Switch"/>
                <Node name="Repeat" type="List"/>
            </SwitchNode>
        </NodeList>
    </ComplexType>
    <SimpleType type="Word" nativeType="IMPL::Text::Schema::Word"/>
    <SimpleType type="Regexp" nativeType="IMPL::Text::Schema::Regexp"/>
    <ComplexType type="Switch" nativeType="IMPL::Text::Schema::Switch">
        <NodeList>
            <SwitchNode minOccur="1" maxOccur="unbounded">
                <Node name="Word" type="Word"/>
                <Node name="Statement" type="Word"/>
                <Node name="Regexp" type="Regexp"/>
                <Node name="Switch" type="Switch"/>
                <Node name="Repeat" type="List"/>
            </SwitchNode>
        </NodeList>
    </ComplexType>
    <ComplexType type="Repeat" nativeType="IMPL::Text::Schema::Repeat">
        <NodeList>
            <SwitchNode minOccur="1" maxOccur="unbounded">
                <Node name="Word" type="Word"/>
                <Node name="Statement" type="Word"/>
                <Node name="Regexp" type="Regexp"/>
                <Node name="Switch" type="Switch"/>
                <Node name="Repeat" type="List"/>
            </SwitchNode>
        </NodeList>
    </CoomplexType>
</schema>

=head1 DESCRIPTION

Схема текстового файла, которую можно использовать для разбора содержимого
текстового файла.

Схема текстового файла состоит из выражений.
1. Регулярное выражение является выражением
2. Строковое значение является выражением.
3. Выражения объединенные логическими операторами также выражение.

Допускаются следующие операторы
1. Повтор
2. Ветвление

=head1 METHODS

=over

=item C<<$schema->compile()>>

Возвращает объект для разбора текста.

=back

=head1 INTERNALS


=cut
