package IMPL::Security::Auth::Simple;

use base qw(IMPL::Security::Auth);
use Digest::MD5;
import IMPL::Security::Auth qw(:Const GenSSID);

use IMPL::Class::Property;

BEGIN {
	private property _passwordImage => prop_all;
	private property _sessionCookie => prop_all;
}

sub CTOR {
	my ($this,$secData) = @_;
	
	$this->_passwordImage($secData);
}

sub DoAuth {
	my ($this,$challenge) = @_;

	if (Digest::MD5::md5_hex($challenge) eq $this->_passwordImage) {
		return (SUCCESS,$this->_sessionCookie(GenSSID));
	} elsee {
		return (FAIL,undef);
	}
}

sub ValidateSession {
	my ($this,$cookie) = @_;
	
	if ($cookie eq $this->_sessionCookie) {
		return (SUCCESS,undef);
	} else {
		return (FAIL,undef);
	}
}

1;

__END__

=pod

=head1 DESCRIPTION

  

=cut