package Schema::Form::Filter;
use strict;
use Common;
our @ISA = qw(Object);

my %LoadedModules;

BEGIN {
    DeclareProperty Name => ACCESS_READ;
    DeclareProperty Class => ACCESS_READ;
    DeclareProperty Args => ACCESS_READ;
    DeclareProperty Attributes => ACCESS_READ;
    DeclareProperty _Instance => ACCESS_READ;
}

sub CTOR {
    my ($this,%args) = @_;
    
    $this->{$Name} = $args{'Name'} or die new Exception('A filter name is required');
    $this->{$Class} = $args{'Class'} or die new Exception('A filter class is required');
    $this->{$Args} = $args{'Args'};
    $this->{$Attributes} = {};
}

sub Create {
    my ($this) = @_;
    
    if (not $LoadedModules{$this->{$Class}}) {
        eval "require $this->{$Class};" or die new Exception('Can\'t load the specified filter',$this->{$Name},$this->{$Class},$@);
        $LoadedModules{$this->{$Class}} = 1;
    }
    
    return $this->{$Class}->new($this->{$Name},$this->{$Attributes}{'message'},$this->Args);
}

sub Instance {
    my ($this) = @_;
    
    if (my $instance = $this->{$_Instance}) {
        return $instance;
    } else {
        return $this->{$_Instance} = $this->Create;
    }
}

1;
