use strict;
package Schema::DataSource::TypeMapping;
use Common;
our @ISA = qw(Object);

BEGIN {
    DeclareProperty Mappings => ACCESS_NONE;
    DeclareProperty DBIdentifierType => ACCESS_READ;
    DeclareProperty DBValueType => ACCESS_READ;
}

sub MapType {
    my ($this,$Type) = @_;
    
    if (my $mapped = $this->{$Mappings}->{$Type->Name->Canonical}) {
        return $mapped;
    } elsif ($Type->Attributes and $Type->GetAttribute('ValueType')) {
        return $this->{$DBValueType};
    } else {
        return $this->{$DBIdentifierType};
    }
}

package Schema::DataSource::TypeMapping::Std;
use Schema::DB::Type;
our @ISA = qw(Schema::DataSource::TypeMapping);

sub CTOR {
    my ($this) = @_;
    $this->SUPER::CTOR(
        Mappings => {
            Identifier => new Schema::DB::Type(Name => 'Integer'),
            String => new Schema::DB::Type(Name => 'varchar', MaxLength => 255),
            Integer => new Schema::DB::Type(Name => 'Integer'),
            Float => new Schema::DB::Type(Name => 'Real'),
            DateTime => new Schema::DB::Type(Name => 'DateTime'),
            Bool => new Schema::DB::Type(Name => 'Tinyint'),
            Blob => new Schema::DB::Type(Name => 'Blob'),
            Text => new Schema::DB::Type(Name => 'Text')
        },
        DBIdentifierType => new Schema::DB::Type(Name => 'Integer'),
        DBValueType => new Schema::DB::Type(Name => 'varchar', MaxLength => 255)
    );
}

1;
