use strict;
package IMPL::Web::TT::Form;

use base qw(IMPL::Web::TT::Control);

use IMPL::Class::Property;
use IMPL::DOM::Navigator::SchemaNavigator;
use IMPL::DOM::Property qw(_dom);

__PACKAGE__->PasssThroughArgs;

BEGIN {
	public property base => prop_all;
	public property schema => prop_all;
	public property errors => prop_all;
	public property data => prop_all;
}

sub CTOR {
	my ($this) = @_;
	
	$this->base($this->nodeName) unless $this->base;
	
	die new IMPL::InvalidArgumentException('A schema is required for a form',$this->nodeName)
		unless eval { $this->schema->isa( typeof IMPL::DOM::Schema ) };
	
	die new IMPL::InvalidOperationException('Can\'t find a form definition in a schema',$this->nodeName,$this->base)
		unless $this->schema->selectNodes(sub { $_->nodeName eq 'ComplexNode' and $_->name eq $this->base });
}

sub createControl {
	my ($this, $path, $class, $hashArgs) = @_;
	
	my $navi = new IMPL::DOM::Navigator::SchemaNavigator($this->schema);
	
	$navi->NavigateName($_) or die new IMPL::InvalidAgrumentException(
		"Can't find a definition for an element",
		$_,
		$path,
		$this->element
	) foreach $this->base, split /\./,$path;
	
	my $schema = $navi->Current;
	my @errors = grep $_->Source == $navi->SourceSchemaNode
}


1;

__END__

=pod

=head1 NAME

C<IMPL::Web::TT::Form> -   

=head1 DESCRIPTION

  ,     
 

=cut