package IMPL::Web::QueryHandler::PageFormat;
use base qw(IMPL::Web::QueryHandler IMPL::Object::Autofill);

__PACKAGE__->PassThroughArgs;

use IMPL::Class::Property;
use IMPL::Web::TT::Document;
use File::Spec;
use Error qw(:try);

BEGIN {
	public property templatesCharset => prop_all;
	public property templatesBase => prop_all;
}

sub CTOR {
	my ($this) = @_;
	
	$this->templatesCharset('utf-8') unless $this->templatesCharset;
	$this->templatesBase('.') unless $this->templatesBase;
}

sub Process {
	my ($this,$action,$nextHandler) = @_;
	
	my $doc = new IMPL::Web::TT::Document();
	
	try {
		my @path = split /\//, $ENV{PATH_TRANSLATED};
		
		$doc->LoadFile ( File::Spec->catfile($this->templatesBase,@path), $this->templatesCharset );
		
		$action->response->contentType('text/html');
		my $hOut = $action->response->streamBody;
		
		print $hOut $doc->Render();
	} finally {
		$doc->Dispose;
	};
}

1;

__END__

=pod

=head1 NAME

C<IMPL::Web::QueryHandler::PageFormat> -     HTML ,   .

=head1 SYNOPSIS

   

=begin code xml

<handlersQuery type="IMPL::Object::List">
	<item type="IMPL::Web::QueryHandler::PageFormat">
		<charsetTemplates>utf-8</charsetTemplates>
	</item>
</handlersQuery>

=end code xml



=begin code

my $app = new IMPL::Web::Application();
$app->handlersQuery->Add(
	new IMPL::Web::QueryHandler::PageFormat( charsetTemplates=> 'utf-8' );
);

=end

=head1 DESCRIPTION

    .  ,    
 C<ENV{PATH_INFO}>     C<templatesBase>.

  C<IMPL::Web::QueryHandler>   
     C<Process>.

C<Serializable>

=head1 MEMBERS

=over

=item C<CTOR(%props)>

     .

=item C<[get,set] templatesCharset>

 .   utf-8.

=item C<[get,set] templatesBase>

    .

=item C<[override] Process($action,$nextHandler)>

,  C<IMPL::Web::QueryHandler->Process>    
  .

=back

=cut