package IMPL::Config::Reference;
use strict;

use IMPL::Exception;

__PACKAGE__->PassThroughArgs;

sub restore {
	my ($self,$data,$surrogate) = @_;
	
	my @path;
	
	my ($tagTarget,$target) = splice @$data, 0, 2;
	
	die new IMPL::Exception('A traget tag must be the first tag in the reference specification') unless $tagTarget eq 'target';
	
	while(my ($method,$args) = splice @$data, 0, 2 ) {
		$target = $self->_Invoke({ method => $method, args => $args});
	}
	return $target;
}

sub _InvokeMember {
    my ($self,$object,$member) = @_;
    
    my $method = $member->{method};
    
    local $@;
    return eval {
        ref $object eq 'HASH' ?
            $object->{$method}
            :
            $object->$method(
                exists $member->{args} ?
                    _as_list($member->{args})
                    :
                    ()
            )
    };
}

sub _as_list {
    ref $_[0] ?
        (ref $_[0] eq 'HASH' ?
            %{$_[0]}
            :
            (ref $_[0] eq 'ARRAY'?
                @{$_[0]}
                :
                $_[0]
            )
        )
        :
        ($_[0]);
}

1;

__END__

=pod

=head1 NAME

C<IMPL::Config::Reference> - ссылка на внешний объект, вычисляемый на этапе десериализации данных.

=head1 SYNOPSIS

=begin code xml

<Application>
	<processingStack type="IMPL::Config::Reference">
	   <target>IMPL::Config</target>
	   <LoadXMLFile>stdprocessing.xml</LoadXMLFile>
	</processingStack>
</Application>

=end code xml

=head1 DESCRIPTION

Позволяет на указвать ссылки на вычисляемые объекты, например, загружаемые из файлов. Ссылки такого рода
будут вычислены на этапе десериализации еще до того, как будет создан объект верхнего уровня, поэтому
следует избегать таких ссылок на сам (его свойства и методы) десериализуемый объект.  

=head1 MEMBERS

=head2 C<restore($class,$data,$surrogate)>

Использует данные переданные в параметре дата C<$data> для вычисления свойства. Данный метод - стандартный
метод для десериализации объекта, а параметр C<$data> содержит пары значений C<(имя_узла,значение_узла)>,
первая пара обязательно является узлом C<target>, а его значение - целевой объект, который будет
использован для вычисления конечного значения.

=back

=cut