package IMPL::SQL::Schema::MySQL::EnumType;
use strict;

use IMPL::Const qw(:prop);
use IMPL::declare {
    base => [
        'IMPL::SQL::Schema::Type' => '@_'
    ],
    props => [
        enumValues => PROP_RO | PROP_LIST 
    ]
};

our @ENUM_TYPES = qw(ENUM SET);

sub CTOR {
    my $this = shift;
    
    die ArgException->new(name => "The specified name is invalid", $this->name)
        unless grep uc($this->name) eq $_, @ENUM_TYPES;
}

1;