package IMPL::Object::Singleton;
use strict;
use warnings;

my %instances;

sub instance {
    my $self = shift;
    
    $instances{$self} || ($instances{$self} = $self->new(@_));
}

1;

__END__

=pod

=head1 SYNOPSIS

package Foo;

use base qw(IMPL::Object IMPL::Object::Singleton);

#....

Foo->isnatnce->some_work();

Foo->isnatnce->get_result();

=head1 DESCRIPTION

  Singleton

=head1 MEMBERS

=head2 OPERATORS

=list

=item C<instance CLASS(@params)>

    ,    ,      C<@params>.

=over

=cut