package IMPL::DOM::Schema::AnyNode;
use strict;
use warnings;

use base qw(IMPL::DOM::Schema::Node);

our %CTOR = (
    'IMPL::DOM::Schema::Node' => sub {
        my %args = @_;
        $args{nodeName} ||= 'AnyNode';
        $args{name} = '::any';
        
        %args;
    }
);

1;

__END__

=pod

=head1 DESCRIPTION

   ,      
 .

   C<IMPL::DOM::Schema::NodeSet>       
      C<IMPL::DOM::Schema::SwitchNode>.

   <IMPL::DOM::Schema::NodeList>      
          .

<NodeList>
    <SimpleNode name="firstName"/>
    <SimpleNode name="age"/>
    <AnyNode type="Notes" minOccur="0" maxOccur="unbounded"/>
    <Node name="primaryAddress" type="Address"/>
    <AnyNode/>
</NodeList>

=cut