package IMPL::ORM::Schema::Field;
use strict;
use warnings;

use base qw(IMPL::DOM::Node);
use IMPL::Class::Property;

BEGIN {
    public property fieldName => prop_get | owner_set;
    public property fieldType => prop_get | owner_set;
    public property fieldNullbale => prop_get | owner_set;
}

our %CTOR = (
    'IMPL::DOM::Node' => sub { nodeName => 'Field' }
);

sub CTOR {
    my ($this,$name,$type,$nullable) = @_;
    
    $this->fieldName($name) or die new IMPL::InvalidArgumentException('A name is required for the field');
    $this->fieldType($type) or die new IMPL::InvalidArgumentException('A type is required for the field');
    $this->fieldNullbale(1) if $nullable;
}

sub canHaveChildren {
    0;
}

1;
