package IMPL::Security::Context;
use strict;
use warnings;

use base qw(IMPL::Object);

use IMPL::Class::Property;

require IMPL::Security::Principal;

my $current = __PACKAGE__->nobody;
my $nobody;

BEGIN {
    public property Principal => prop_get;
    public property AssignedRoles => prop_all;
}

sub Impersonate {
    my ($this,$code) = @_;
    
    my $old = $current;
    my $result;
    local $@;
    eval {
        $result = $code->();
    };
    $current = $old;
    if($@) {
        die $@;
    } else {
        return $result;
    }
}

sub nobody {
    my ($self) = @_;
    $nobody = $self->new(Principal => IMPL::Security::Principal->nobody, AssignedRoles => undef) unless $nobody;
    $nobody;
}

1;
