package IMPL::DOM::Schema::AnyNode;
use strict;
use warnings;

use parent qw(IMPL::DOM::Schema::Node);

our %CTOR = (
    'IMPL::DOM::Schema::Node' => sub {
        my %args = @_;
        $args{nodeName} ||= 'AnyNode';
        $args{name} = '::any';
        
        %args;
    }
);

1;

__END__

=pod

=head1 DESCRIPTION

Узел с произвольным именем, для этого узла предусмотрена специальная проверка
в контейнерах.

В контейнерах типа C<IMPL::DOM::Schema::NodeSet> этот узел можно использовать только один раз
причем его использование исключает использование узла C<IMPL::DOM::Schema::SwitchNode>.

В контейнерах типа С<IMPL::DOM::Schema::NodeList> данный узел может применяться несколько раз
для решения таких задачь как последовательности разноименных узлов с одним типом.

<NodeList>
    <SimpleNode name="firstName"/>
    <SimpleNode name="age"/>
    <AnyNode type="Notes" minOccur="0" maxOccur="unbounded"/>
    <Node name="primaryAddress" type="Address"/>
    <AnyNode/>
</NodeList>

=cut
