package IMPL::Code::Loader;
use strict;
use warnings;

my %packages;

sub Provide {
	my ($self,$package) = @_;
	
	my ($declaringPackage,$file) = caller();
	$packages{$package} = { declaringPackage => $declaringPackage, file => $file, evidence => 'provide' };
}

sub Require {
	my ($self,$package) = @_;
	
	return 1 if $packages{$package};
	
	if (my $file = $INC{$package}) {
		$packages{$package} = { file => $file, evidence => 'inc' };
		return 1;
	} 
	
	undef $@;
	
	if ( eval "require $package; 1;" and not $packages{$package}) {
		$packages{$package} = { file => $INC{$package}, evidence => 'inc' };
	};
			
	die $@ if $@ and not $!;
}

1;

