package IMPL::DOM::Property;
use strict;
use warnings;

require IMPL::Exception;

use parent qw(Exporter);
our @EXPORT_OK = qw(_dom);

sub _dom($) {
    my ($prop_info) = @_;
    $prop_info->Attributes->{domProperty} = 1;
    return $prop_info;
}

1;
__END__
=pod

=head1 SYNOPSIS

package TypedNode;

use parent qw(IMPL::DOM::Node);
use IMPL::DOM::Property qw(_dom);

BEGIN {
    public _dom property Age => prop_all;
    public _dom property Address => prop_all;
    public property ServiceData => prop_all;
}

=head1 DESCRIPTION

Позволяет объявлять свойства, которые будут видны в списке свойств.

=cut
